<?php
	echo "<b>Prueba 8.3: Proteccion de datos III - Encriptacion con el sistema MCrypt</b><br><br>";
	echo  "El sistema de encriptacion MCrypt cuenta con cuatro modos de cifrado soportados. PAra cada uno se establece una forma de actuar, estos modos combinados con los algoritmos de cifrado, la semilla y el texto a encriptar dan un resultado de alto nivel y que difieren en el grado de seguridad dependiendo del modo utilizado.<br><br>";
	
	$clave = "casa";
	$semilla = "LG";
	
	echo "Clave a cifrar: ".$clave."<br>Semilla usada: ".$semilla;
	$td=mcrypt_module_open('tripledes','','ecb','');
	$VI = mcrypt_create_iv(mcrypt_enc_get_iv_size($td),MCRYPT_RAND); //Vector de inicializacion necesario para cifrar los datos (tamao del bloque, semilla fuente)
?>
	<table border="2" align="center" bgcolor="#ffffcc">
		<caption align="center"><b>TABLA DE CIFRADOS</b></caption>
		<tr bgcolor="#999999">
			<td align="center"><b>CIFRADO ECB</b></td>
			<td align="center"><b>CIFRADO CBC</b></td>			
			<td align="center"><b>CIFRADO CFB</b></td>
			<td align="center"><b>CIFRADO OFB</b></td>
		</tr>
		<tr bgcolor="#cccccc">
			<td align="center"><?php echo mcrypt_ecb(MCRYPT_BLOWFISH,$semilla,$clave,MCRYPT_ENCRYPT,$VI); ?></td><!-- Encriptacion ECB -->
			<td align="center"><?php echo mcrypt_cbc(MCRYPT_GOST,$semilla,$clave,MCRYPT_ENCRYPT,$VI); ?></td><!-- Encriptacion CBC -->
			<td align="center"><?php echo mcrypt_cfb(MCRYPT_TripleDES,$semilla,$clave,MCRYPT_ENCRYPT,$VI); ?></td><!-- Encriptacion CFB -->
			<td align="center"><?php echo mcrypt_ofb(MCRYPT_RC2,$semilla,$clave,MCRYPT_ENCRYPT,$VI); ?></td><!-- Encriptacion OFB -->
		</tr>
		<tr>
			<td align="center">
				ECB (electronic codebook o libro de codigos electronico) va bien para datos aleatorios, tales como encriptar otras claves. Puesto que los datos son cortos y aleatorios.
			</td>
			<td align="center">
				CBC (cipher block chaining o cifrado en bloque encadenado) es especialmente util para encriptar ficheros, donde incrementa significativamente la seguridad por encima de ECB.
			</td>
			<td align="center">
				CFB (chiper feedback o cifrado realimentado) es el mejor modo de encriptar flujos de bytes donde cada byte debe ser encriptado.
			</td>
			<td align="center">
				OFB (output feedback o salida realimentada) es comparable al CFB, pero puede usarse en aplicaciones donde la propagacion de errores no puede tolerarse.
			</td>
		</tr>
	</table>
	<?php
		echo "<br>De forma suplementaria se han utilizado diferentes algoritmos de encriptacion de los disponibles. Estos son solo una muestra de los que realmente hay.<br><br>Si lo que se quiere es desencriptar en lugar de MCRYPT_ENCRYPT se debe utilizar MCRYPT_DECRYPT.<br><br>";
		echo "<b><u>ATENCION:</u></b> Se pueden encriptar varias veces los strings y no necesariamente se debe hacer con el mismo algoritmo de cifrado ni tampoco con el mismo metodo.";
	?>